/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbNode {
    static final int ELEMENT_TYPE = 1;
    private Document m_root = null;
    private Node m_domNode;
    private String[] m_elementTypes;

    public DbNode(Node node) {
        this.m_domNode = node;
        this.m_elementTypes = null;
    }

    public DbNode(Document document, Node node) {
        this.m_domNode = node;
        this.m_root = document;
        this.m_elementTypes = null;
    }

    public Document getDocument() {
        return this.m_root;
    }

    public void setElementFilter(String[] stringArray) {
        this.m_elementTypes = stringArray;
    }

    public String getName() {
        return this.m_domNode.getNodeName();
    }

    public String getValue() {
        return this.m_domNode.getTextContent();
    }

    public int getIntValue() {
        String string = this.m_domNode.getTextContent();
        if (string.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public boolean getBoolValue() {
        return this.m_domNode.getTextContent().equalsIgnoreCase("true");
    }

    public int getNodeCount() {
        if (this.m_domNode == null) {
            return 0;
        }
        int n = 0;
        NodeList nodeList = this.m_domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.isElement(node)) continue;
            ++n;
        }
        return n;
    }

    public DbNode getNode(int n) {
        int n2 = 0;
        NodeList nodeList = this.m_domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.isElement(node) || n2++ != n) continue;
            return new DbNode(node);
        }
        return null;
    }

    public DbNode getNode(String string) {
        Node node = this.getDomNode(string);
        if (node != null) {
            return new DbNode(node);
        }
        return null;
    }

    public DbNode createChild(String string) {
        if (this.m_root == null) {
            return null;
        }
        Element element = (Element)this.m_domNode;
        Element element2 = this.m_root.createElement(string);
        element.appendChild(element2);
        return new DbNode(this.m_root, element2);
    }

    public String getAttr(String string) {
        NamedNodeMap namedNodeMap = this.m_domNode.getAttributes();
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    public boolean getBoolAttr(String string) {
        String string2 = this.getAttr(string);
        return string2.equalsIgnoreCase("true");
    }

    public void addAttr(String string, String string2) {
        if (this.m_root == null) {
            return;
        }
        Element element = (Element)this.m_domNode;
        element.setAttribute(string, string2);
    }

    public void addAttr(String string, boolean bl) {
        this.addAttr(string, Boolean.toString(bl));
    }

    public void addAttr(String string, long l) {
        this.addAttr(string, Long.toString(l));
    }

    public boolean getBoolElement(String string) {
        String string2 = this.getElement(string);
        return string2.equalsIgnoreCase("true");
    }

    public int getIntElement(String string) {
        String string2 = this.getElement(string);
        if (string2.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public String getElement(String string) {
        Node node = this.getDomNode(string);
        if (node != null) {
            return node.getTextContent();
        }
        return "";
    }

    public void addElement(String string, String string2) {
        if (this.m_root == null) {
            return;
        }
        Element element = this.m_root.createElement(string);
        element.setTextContent(string2);
        ((Element)this.m_domNode).appendChild(element);
    }

    public void addElement(String string, boolean bl) {
        this.addElement(string, Boolean.toString(bl));
    }

    public void addElement(String string, int n) {
        this.addElement(string, Integer.toString(n));
    }

    public String getText() {
        return this.m_domNode.getTextContent();
    }

    private boolean isElement(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        if (this.m_elementTypes != null) {
            for (String string : this.m_elementTypes) {
                if (!string.equals(node.getNodeName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Node getDomNode(String string) {
        NodeList nodeList = this.m_domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!this.isElement(node) || !string.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }
}

